//
//  Displaying_Pins_with_Different_Colors_on_a_Map_ViewViewController.m
//  Displaying Pins with Different Colors on a Map View
//
//  Created by Vandad Nahavandipoor on 15/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Displaying_Pins_with_Different_Colors_on_a_Map_ViewViewController.h"
#import "MyAnnotation.h"

@implementation
  Displaying_Pins_with_Different_Colors_on_a_Map_ViewViewController

@synthesize myMapView;

- (void)didReceiveMemoryWarning{
  [super didReceiveMemoryWarning];
}

- (MKAnnotationView *)mapView:(MKMapView *)mapView 
            viewForAnnotation:(id <MKAnnotation>)annotation{
  
  MKAnnotationView *result = nil;
  
  if ([annotation isKindOfClass:[MyAnnotation class]] == NO){
    return result;
  }
  
  if ([mapView isEqual:self.myMapView] == NO){
    /* Zdarzenie ma być przetworzone tylko dla utworzonego wcześniej widoku mapy. */
    return result;
  }
  
  /* Najpierw rzutujemy opis, dla którego widok mapy wygenerował daną wiadomość delegata. */
  MyAnnotation *senderAnnotation = (MyAnnotation *)annotation;
  
  /* Używając metody klasy zdefiniowanej w klasie opisu, próbujemy otrzymać możliwy do ponownego użycia identyfikator pinezki, która zostanie utworzona. */
  NSString *pinReusableIdentifier = 
  [MyAnnotation 
   reusableIdentifierforPinColor:senderAnnotation.pinColor];
  
  /* Używając pobranego wcześniej identyfikatora, próbujemy ponownie wykorzystać pinezkę w widoku mapy. */
  MKPinAnnotationView *annotationView = (MKPinAnnotationView *)
  [mapView  
   dequeueReusableAnnotationViewWithIdentifier:pinReusableIdentifier];
  
  if (annotationView == nil){
    /* Jeżeli nie uda się wykorzystać istniejącej pinezki, trzeba utworzyć nową. */
    annotationView =  [[MKPinAnnotationView alloc] 
                       initWithAnnotation:senderAnnotation
                       reuseIdentifier:pinReusableIdentifier];
    
    /* Upewniamy się o możliwości wyświetlenia tytułu i (lub) podtytułu, o ile zostały zdefiniowane dla pinezki. */
    [annotationView setCanShowCallout:YES];
  }
  
  /* Niezależnie od tego, czy wykorzystaliśmy istniejącą, czy utworzyliśmy nową pinezkę,
   upewniamy się, że kolor pinezki odpowiada kolorowi opisu. */
  annotationView.pinColor = senderAnnotation.pinColor;
  
  result = annotationView;
  
  return result;
}

- (void)viewDidLoad {
  [super viewDidLoad];
  
  /* Utworzenie mapy wypełniającej cały ekran. */
  self.myMapView = [[MKMapView alloc] 
                    initWithFrame:self.view.bounds];
  
  self.myMapView.delegate = self;
  
  /* Tworzona mapa ma być standardowa. */
  self.myMapView.mapType = MKMapTypeStandard;
  
  self.myMapView.autoresizingMask = 
    UIViewAutoresizingFlexibleWidth |
    UIViewAutoresizingFlexibleHeight;
  
  /* Dodanie mapy do widoku. */
  [self.view addSubview:self.myMapView];
  
  /* To tylko przykładowe położenie. */
  CLLocationCoordinate2D location;
  location.latitude = 50.288865;
  location.longitude = 18.662042;
  
  /* Utworzenie opisu na podstawie położenia. */
  MyAnnotation *annotation = 
  [[MyAnnotation alloc] initWithCoordinates:location
                                      title:@"Gliwice"
                                   subTitle:@"Wydawnictwo Helion"];
  
  annotation.pinColor = MKPinAnnotationColorPurple;
  
  /* Umieszczenie opisu na mapie. */
  [self.myMapView addAnnotation:annotation];
  
}

- (void)viewDidUnload{
  [super viewDidUnload];
  self.myMapView = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
